// @flow
import d3 from 'd3';
import $ from 'jquery';

var margin = {top: 30, right: 120, bottom: 30, left: 80},
  width = 960 - margin.left - margin.right,
  height = 500 - margin.top - margin.bottom;

var x = d3.time.scale()
  .range([0, width]);

var y = d3.scale.linear()
  .range([height, 0]);

var xAxis = d3.svg.axis()
  .scale(x)
  .orient('bottom');

var yAxis = d3.svg.axis()
  .scale(y)
  .orient('left')
  .tickFormat(d3.format('d'));

function addLegendTo(container : $, pattern : string, colorStyleClass : string) {
  const columns = [pattern];

  const legendWrapper = $('<div class="legend-wrapper">').appendTo(container);

  const legendDiv = $('<div class="legend">').appendTo(legendWrapper);
  const legendUl = $('<ul>').appendTo(legendDiv);

  const legendBoxClasses = 'color-legend-box' + ' ' + colorStyleClass;

  d3.select(legendUl.get(0))
    .selectAll('li')
    .data(columns)
    .enter()
    .append('li')
    .html((column) => {
      return `<span class="${legendBoxClasses}"></span> ${column}`;
    });
}

export function drawCommitMessageTrend(container : $, data : Array<any>, pattern : string) {

  addLegendTo(container, pattern, 'revisions-line-legend');

  var line = d3.svg.line()
    .x(function(d) { return x(d.date); })
    .y(function(d) { return y(d.nrevisions); });

  var svg = d3.select(container.get(0)).append('svg')
    .attr('preserveAspectRatio', 'xMidYMid meet')
    .attr('viewBox', '0 0 ' + (width + margin.left + margin.right) + ' ' + (height + margin.top + margin.bottom))
    .attr('width', width + margin.left + margin.right)
    .attr('height', height + margin.top + margin.bottom)
    .append('g')
    .attr('transform', 'translate(' + margin.left + ',' + margin.top + ')');

  x.domain(d3.extent(data, function(d) { return d.date; }));
  y.domain([0, d3.max(data, function(d) { return parseInt(d.nrevisions) + 1; })]);

  svg.append('g')
    .attr('class', 'x axis')
    .attr('transform', 'translate(0,' + height + ')')
    .call(xAxis);

  svg.append('g')
    .attr('class', 'y axis')
    .call(yAxis)
    .append('text')
    .attr('transform', 'rotate(-90)')
    .attr('y', 6)
    .attr('dy', '.71em')
    .style('text-anchor', 'end')
    .attr('class', 'revisions-label')
    .text('Number of Commits');

  svg.append('path')
    .datum(data)
    .attr('class', 'revisions-line')
    .attr('d', line);
}

export function drawCodeChurnTrend(container : $, data : Array<any>, pattern : string) {

  addLegendTo(container, pattern, 'added-lines-legend');

  var line = d3.svg.line()
    .x(function(d) { return x(d.date); })
    .y(function(d) { return y(d.addedcode); });

  var svg = d3.select(container.get(0)).append('svg')
    .attr('preserveAspectRatio', 'xMidYMid meet')
    .attr('viewBox', '0 0 ' + (width + margin.left + margin.right) + ' ' + (height + margin.top + margin.bottom))
    .attr('width', width + margin.left + margin.right)
    .attr('height', height + margin.top + margin.bottom)
    .append('g')
    .attr('transform', 'translate(' + margin.left + ',' + margin.top + ')');

  x.domain(d3.extent(data, function(d) { return d.date; }));
  y.domain([0, d3.max(data, function(d) { return parseInt(d.addedcode) + 1; })]);

  svg.append('g')
    .attr('class', 'x axis')
    .attr('transform', 'translate(0,' + height + ')')
    .call(xAxis);

  svg.append('g')
    .attr('class', 'y axis')
    .call(yAxis)
    .append('text')
    .attr('transform', 'rotate(-90)')
    .attr('y', 6)
    .attr('dy', '.71em')
    .style('text-anchor', 'end')
    .attr('class', 'added-lines-label')
    .text('Added Lines of Code');

  svg.append('path')
    .datum(data)
    .attr('class', 'added-lines')
    .attr('d', line);
}
