-- name: delete-all-warnings!
-- Removes all warning definitions.
delete from warnings;

-- name: drop-warnings!
-- Drops the warnings table.
drop table warnings;

-- name: get-all-warnings
-- Returns all triggered warnings in the system independent of analysis or repo.
select id, name, description, analysis, is_short_format from warnings
       order by name asc;

-- name: get-triggered-warnings-for-analysis
-- Returns all warnings triggered for the given analysis.
select name, description, analysis, is_short_format from warnings
       where analysis = ?;

-- name: insert-warning!
-- Inserts a supported type of warning to be associated with a repository later.
insert into warnings
       (name, description, analysis, is_short_format)
       values(:name, :description, :analysis, :is_short_format);

