grammar VisualBasicNestedComplexity;
options {superClass=hotspots_x_ray.languages.InterruptibleParser;}
import VisualBasicSharedRulesLexer;

// Overrides
NEWLINE : '\r'? '\n';

// This grammar detects islands of nested complexity.

method
:
	expression* EOF
;

expression : complexity
           | anything;

complexity: single_if_line
          | do_while_loop
          | do_until_loop
          | do_loop_while_loop
          | do_loop_until_loop
          | while_loop
          | for_each_loop
          | for_next_loop
          | if_clause
          | select_case;

anything: .;

// The single line if's have to be filtered away to distinuish
// them from a multiline if that might have nested complexity.
// An example: If Not value.Contains("%") Then Return value
single_if_line: IF if_condition_exprs THEN ~(NEWLINE)+? NEWLINE;

// NOTE: no explit check for ELSE -- it's considered part of the IF's nesting depth.
// This choice simplifies the grammar without losing accuracy.
if_clause: IF if_condition_exprs THEN NEWLINE expression*? END_IF;

// NOTE: a trade-off since we don't have many VB users and aren't expecting this space to grow.
// We only catch Complex Conditionals in if-statements, no inside loops. This is likely to
// capture the most severe code smells.
if_condition_exprs: if_condition_expr+;
if_condition_expr: conditional_operator
                 | ~(THEN);
conditional_operator: AND | AndAlso | OR | OrElse;

while_loop: WHILE expression*? END_WHILE;
do_while_loop: DO_WHILE expression*? LOOP;
do_until_loop: DO_UNTIL expression*? LOOP;
do_loop_while_loop: DO expression*? LOOP_WHILE;
do_loop_until_loop: DO expression*? LOOP_UNTIL;

for_each_loop: FOR EACH expression*? NEXT;
for_next_loop: FOR ~(TO | EACH)+ TO expression*? NEXT; // NOTE: STEP is optional!

select_case: SELECT_CASE expression*? END_SELECT;
