grammar ScalaSharedRulesParser;
options {superClass=hotspots_x_ray.languages.InterruptibleParser;}

import ScalaSharedRulesLexer;

anything : ~(LeftBrace | RightBrace);

id_name: ID_WORD | ID_SPECIAL;

function_name : id_name;

generic_signature : '[' ~(']' | LeftBrace)*? ']';

function_return_signature :  ~('=' | LeftBrace | DEF)* ':' ~(LeftBrace | '=' | DEF)+;

function_body_block : fn_body_block_content+
                   ;

fn_body_block_content : LeftBrace function_body RightBrace
                     | LeftParen fn_body_block_content function_body_expression? RightParen;

function_body_expression : ~(DEF | LeftBrace | RightBrace | 'protected' | 'implicit' |
                                    'private' | 'public' | 'lazy' | 'val' | 'var' | '@' | FINAL |
                                    'sealed' | 'abstract' | 'override' | 'import' | CLASS | OBJECT | TRAIT);

function_body : function_body_statement*;

function_body_statement : block_statement
                        | any_function_statement;

block_statement : LeftBrace function_body_statement*? RightBrace;

any_function_statement : ~(LeftBrace | RightBrace);

