grammar ScalaConsecutiveAssertions;
options {superClass=hotspots_x_ray.languages.InterruptibleParser;}

singlefunctionscope
:
	expression* EOF
;

expression : assertion_blocks
           | .;

assertion_blocks: assertion_statement+;

assertion_statement: scala_test_assert
                   | assert_result;

assert_result: ASSERT_RESULT assert_condition LeftBrace .*? RightBrace;

scala_test_assert: assertion_type assert_condition SEMICOLON?;
assertion_type: ASSERT | ASSERT_NO_COMPILE | ASSERT_TYPE | ASSERT_COMPILES | ASSUME;

assert_condition: LeftParen assert_parts*? RightParen;

assert_parts: LeftParen assert_parts*? RightParen
            | .;

ASSERT_NO_COMPILE: 'assertDoesNotCompile';
ASSERT_COMPILES: 'assertCompiles';
ASSERT_TYPE: 'assertTypeError';
ASSERT: 'assert';

ASSERT_RESULT: 'assertResult';

ASSUME: 'assume';

fragment ESCAPED : '\\\\' | '\\"';
LITERAL : '"' ( ESCAPED | ~('\n'|'\r') )*? '"';

LITERAL_CHAR : '\'' . '\'' -> skip;

LeftParen : '(';
RightParen: ')';

LeftBrace : '{';
RightBrace : '}';

LeftSquare: '[';
RightSquare: ']';

SEMICOLON : ';';
COLON: ':';

Whitespace : [ \t]+ -> skip;

BlockComment: '/*' .*? '*/' -> skip;
LineComment: '//' ~[\r\n]* -> skip;

NEWLINE : '\r'? '\n' -> skip;

ID_WORD: [a-zA-Z][a-zA-Z_0-9]*;
ID_SPECIAL: [a-zA-Z_][a-zA-Z_0-9]*
          | [+-/^%=:]+;

INT : [0-9]+;

ANY_CHAR : .; // Put this lexer rule last to give it the lowest precedence
