grammar GroovyMethodArguments;

import GroovySharedRulesParser;

singlefunctionscope
:
	expression* EOF
;

expression : function_declaration
           | anything; // since we use micro-grammars we might get noise before a method

function_declaration : function_name function_definition_params_list throw_spec? LeftBrace function_body RightBrace;

fun_arg : 'final'? (generic_args | parameter | dynamic) default_value?;
default_value: '=' ~(',' | LeftParen | RightParen)+? (LeftParen ~(RightParen)*? RightParen)?;

type_name: (ID | SCOPED_NAME) '[]'?;

generic_args: type_name generic_type ID;
generic_type: '<' generic_arg_list '>';
generic_arg: ~('<' | '>')*? generic_type?;
generic_arg_list: generic_arg
                 | generic_arg_list ',' generic_arg;

argument_type: type_name;
parameter: argument_type ID;
dynamic: ID;

function_definition_params_list : LeftParen function_definition_params_list_details? RightParen;

function_definition_params_list_details : fun_arg
                                        | function_definition_params_list_details ',' fun_arg;

