grammar CodeSceneDirectives;

expressions: expression* EOF;

expression: directive
          | anything;

directive: DirectiveTag '(' requests+ ')';

requests: request
        | request DirectiveSeparator requests;

request: disable_all
       | disable_specific_rule;

disable_all: DisableAll;
disable_specific_rule: Disable ':' rule_name;
rule_name: LITERAL;

anything: .;

fragment ESCAPED : '\\\\' | '\\"';
LITERAL : '"' ( ESCAPED | ~('"') )*? '"';

// case-insensitive matching of the directive tag
fragment C:('c'|'C');
fragment D:('d'|'D');
fragment E:('e'|'E');
fragment N:('n'|'N');
fragment O:('o'|'O');
fragment S:('s'|'S');
DirectiveTag: '@' C O D E S C E N E ;

DirectiveSeparator: ',';

DisableAll: 'disable-all';
Disable: 'disable';

Whitespace : [ \t]+ -> skip;

ANY_CHAR : .; // Put this lexer rule last to give it the lowest precedence