grammar CSharpComplexity;

method
:
	expression* EOF
;

expression : complexity
           | anything;

complexity: loops | paths | conditionals | switch_expressions;
anything: .;

switch_expressions: SWITCH leading_sequence* '{' pattern_matches+? '}' ';';
pattern_matches: pattern_match_complexity_inducing
               | anything;

pattern_match_complexity_inducing: '=>';

loops: leading_sequence (FOR | WHILE) Whitespace? LEFT_PAREN;

paths: (CATCH Whitespace? LEFT_PAREN) |
       NULLABLE_CHECK |
       (CONTINUE Whitespace? SEMICOLON) |
       (GOTO Whitespace);

conditionals: (leading_sequence (IF Whitespace? LEFT_PAREN) |
                                (CASE Whitespace) |
                                (DEFAULT Whitespace? COLON)) |
              ternary_operator |
              OPERATORS;

ternary_operator: '?' ~(':' | ';' | '{' | IF | FOR | WHILE | CONTINUE | SWITCH)+?  ':';

leading_sequence: Whitespace | NEWLINE;

fragment VERBATIM_ESCAPE : '""';
VERBATIM_STRING : '@' '"' ( VERBATIM_ESCAPE | ~('"'))* '"';

fragment ESCAPED : '\\\\' | '\\"';
LITERAL : '"' ( ESCAPED | ~('"') )*? '"';

IF: 'if';
FOR: 'for' | 'foreach';
WHILE: 'while';
CONTINUE: 'continue';
GOTO: 'goto';
CASE: 'case';
DEFAULT: 'default';
CATCH: 'catch';
SWITCH: 'switch';

ID : [a-zA-Z_][a-zA-Z0-9_]*;

SAFE_NAVIGATION: '?.';

Whitespace : [ \t]+;
NULLABLE_CHECK: '??';
OPERATORS: '&&'
          | '||';

LEFT_PAREN: '(';
COLON: ':';
SEMICOLON: ';';

BlockComment: '/*' .*? '*/' -> skip;
LineComment: '//' ~[\r\n]* -> skip;

NEWLINE : '\r'? '\n';

ANY_CHAR : .; // Put this lexer rule last to give it the lowest precedence
