(ns codescene.features.reports.portfolio.projects
  (:require
   [codescene.features.dashboard.core :as dashboard-common]
   [codescene.features.factors.results :as results]
   [codescene.features.presentation.time-scope :as ts]
   [codescene.features.reports.common.project :as common-project]
   [tick.core :as t]))


(defn with-analysis-infos-and-links [system projects]
  (->> projects
       (map #(common-project/with-analysis-info system %))
       (filter :analysis-id)
       (map #(assoc % :links
                      (common-project/generate-project-links system (:id %) (:analysis-id %)))))
  )

(defn- project-results [{:keys [path-fn] :as project} beginning end]
  (if path-fn
    (let [absolute-analysis-path (path-fn "")
          {:keys [monthago end-date]} (common-project/periods absolute-analysis-path)
          month-renderable-trends (results/->renderable-trends absolute-analysis-path monthago end-date)
          cleaned-month-trends (common-project/clean-renderable-trends month-renderable-trends :month)
          period-statistics (results/period-statistics path-fn monthago end-date)]
      (merge project {:file-summary (dashboard-common/file-summary-per-language absolute-analysis-path)
                      :dashboard (dashboard-common/dashboard-data absolute-analysis-path)
                      :renderable-trends cleaned-month-trends
                      :period-statistics period-statistics
                      :commits-last-month (dashboard-common/commits-last-month absolute-analysis-path)
                      :end end-date
                      :beginning monthago}))
    project))


(defn with-results [projects-with-path-fn scope]
  (let [[beginning end] (ts/interval-from-scope (t/now) scope)
        sorted-projects-with-results (->> projects-with-path-fn
                                          (map #(project-results % beginning end))
                                          (sort-by :commits-last-month #(compare %2 %1)))]
    {:projects sorted-projects-with-results
     :beginning beginning
     :end end}))


(comment
 (let [projects (clojure.edn/read-string
                 (slurp (clojure.java.io/resource "codescene/features/reports/test_data/products-onprem.edn")))]
   (with-results projects {:a "b"} "month")))

