(ns codescene.features.recommendations.event-log.queries
  (:require
   [medley.core :as m]))

(defn or-fn [& preds]
  (fn [thing]
    (boolean (m/find-first (fn [pred] (pred thing)) preds))))

(defn map-as-predicate
  "Given a map, returns a predicate that tests the values in `m` against
  any top-level keys supplied in `pred-template`. The values in
  `pred-template` can be either functions, sets or any other
  value. Functions will be called as predicates on the correponding
  value in `m`; sets will be used to test the corresponding value. Any
  other type (not function, not set) will be checked for simple
  equality."
  [pred-template]
  (fn [m]
    (every?
     (fn [[k v]]
       (when-let [m-v (get m k)]
         (cond (fn? v)
               (v m-v)

               (set? v)
               (contains? v m-v)

               :else
               (= v m-v))))
     pred-template)))

(defn recommendation-as-prerequisite-predicate
  [user-id {:keys [id resolved user-scope] :as _recommendation}]
  (assert (keyword? resolved)  (format "Missing resolved keyword in recommendation def: %s." id))
  (map-as-predicate
    (case user-scope
      :all-project-users
      {:stream :recommendation :event resolved}

      :current-user
      {:stream :recommendation :event resolved :user-id user-id}

      (throw (ex-info
               "Unmatched recommendation user-scope."
               {:unknown-scope user-scope :recommendation-id id})))))
