(ns codescene.features.recommendations.event-log.events)

(defprotocol RecommendationEventLog
  (append-event [this project-id event])
  (reduce-log-for-project
    [this project-id reducing-fn]
    [this project-id reducing-fn xfs])
  (latest-related-events
    [this project-id user-id recommendation])
  (resolved-project-recommendations [this project-id]
    "Returns the *earliest* resolved recommendation for each type of
    recommendation found. We want the earliest recommendation because
    this will primarily be used for evaluating
    prerequisites. Subsequent resolved recommendations do not affect
    prerequisite calculations. ")
  (resolved-project-user-recommendations [this project-id user-id]
    "Same as `resolved-project-recommendations` but narrowed to a
    single user. "))
