(ns codescene.features.recommendations.event-log.atom-log-test-helper-fns
  (:require
   [codescene.features.recommendations.event-log.atom-log :as atom-log]
   [codescene.features.recommendations.event-log.helper-fns :as help])
  (:import (java.time Instant)))

(def base-time  (Instant/ofEpochSecond 1709740313))

(defn event-log-from
  ([events]
   (event-log-from events (help/sequential-timestamps (count events) base-time)))
  ([events times]
   (atom-log/make-test-log
     (mapv
       (fn [ev t] (assoc ev :created t :project-id 5))
       events
       times))))
