(ns codescene.features.components.delta-analysis
  (:require [clojure.spec.alpha :as s]
            [codescene.features.spec.commons :as commons-spec]))

(defprotocol DeltaAnalysisComponent
  (-all-in-project [this project-id])
  (-by-id [this project-id delta-analysis-id]))

(s/fdef all-in-project
        :args (s/cat :this some?
                     :project-id ::commons-spec/id)
        :ret (s/coll-of (s/keys :req-un [::commons-spec/id])))
(defn all-in-project
  "Return all delta analyses in project"
  [this project-id]
  (-all-in-project this project-id))

(s/fdef by-id
        :args (s/cat :this some?
                     :project-id ::commons-spec/id
                     :delta-analysis-id ::commons-spec/id)
        :ret (s/nilable (s/keys :opt-un [::commons-spec/id])))
(defn by-id
  "Return the delta-analysis data by id"
  [this project-id delta-analysis-id]
  (-by-id this project-id delta-analysis-id))
