(ns codescene.features.analytics.util
  "utility methods for analytics"
  (:require
   [codescene.features.security.tokens :as tokens]))

(defn anonymize-string
  "Anonymize `plaintext` with HMAC+SHA256 algo using `secrete-base` to derive the secret key.
  See https://codescene.slab.com/posts/handling-personal-information-pi-pii-1ahdzo91#h5ete-hashing-pi"
  [plaintext secret-base]
  ;; The trouble is: what secret-key should we use?
  ;; Since we don't have a great secret value to use we simply use instance id
  ;; and append a hardcoded string (because instance-id is also sent in the event data)
  (some-> plaintext (tokens/b64-token (str secret-base ".hardcoded-secret-value"))))
