(ns codescene.features.analysis-config.code-comment-biomarkers
  (:require [clojure.string :as str])
  (:import (java.util.regex PatternSyntaxException)))

(defn split-code-comment-pattern-into-regex-and-name
  [p]
  (when-let [n (some-> (re-find #"\(\?\#[^\)]+\)$" p) 
                       (str/replace #"\(\?\#" "") 
                       (str/replace #"\)" ""))]
    (let [cleaned-pattern (str/replace p #"\(\?\#[^\)]+\)$" "")]
      {:complete p
       :biomarker-comment-regex-name n
       :biomarker-comment-regex cleaned-pattern})))

(defn valid-code-comment-pattern? [s]
  (try
    (some? (some-> s
                   split-code-comment-pattern-into-regex-and-name
                   :biomarker-comment-regex
                   re-pattern))
    (catch PatternSyntaxException _e
      false)))
