// @flow
import $ from 'jquery';

import {autoGrowInputList} from '../input-list';

var defaultInit = '0 8 * * 1';

function addPlanCtrl(i, initial) {
  $('#plan_' + i.toString()).cron({
    initial: initial,
    useGentleSelect: true
  });
}

function addPropertyDivs(i) {
  var addedDiv = $('input[name=address_'+i.toString()+']').parent();

  addedDiv.after(
    $('<div/>').attr('id', 'plan_'+i.toString()).addClass('reportplancontent')
  );

  addedDiv.after(
    $('[name=type_0]').clone().attr('name', 'type_'+i.toString())
  );
}

function addHiddenPlanInput(i, init) {
  $('[name=plan_0]').after(
    $('<input/>', {'type':'hidden', 'name':'plan_'+i.toString(), 'value':init}));
}

export function init(reportPlans) {
  for (var i = 0; i < reportPlans.length  ; i++) {
    addPlanCtrl(i, reportPlans[i]);
  }

  var count = reportPlans.length;
  addPlanCtrl(count, defaultInit);

  autoGrowInputList($('#report-list'), {
    prefix: 'address_',
    placeholder: 'Enter another email address...',
    wrapperElems: [
      $('<div>', {'class': 'report-config-row'}),
      $('<div>', {'class': 'report-recipient'})
    ],
    inputFieldCss: 'report-recipient-input',
    siblings: [],
    onBlur: () => {},
    onGrow: () => {
      ++count;
      addPropertyDivs(count);
      addPlanCtrl(count, defaultInit);
      addHiddenPlanInput(count, defaultInit);
    }
  });

  $('#configform').submit(function() {
    var i = 0;
    var plan = $('#plan_0');
    while (plan.length){ //TODO: This is not how to do it...
      var value = plan.cron('value');
      $('[name=plan_'+ i.toString() + ']').attr('value', value);
      ++i;
      plan = $('#plan_' + i.toString());
    }
    return true;
  });
}
