// @flow
import $ from 'jquery';

export function init() {
  const container = $('.confirm-found-repositories');

  const continueForm = container.find('#continue-form');
  const continueButton = continueForm.find('button[type=submit]');

  const scanAgainForm = container.find('#scan-again-form');
  const scanAgainButton = scanAgainForm.find('button[type=submit]');

  const toggleUncheckAll = $('#toggle-uncheck-all');
  
  var allChecked = true;
  
  toggleUncheckAll.on('click', function (event: Event): void {
    event.preventDefault();

    if (allChecked) {
      continueForm.find('input[type=checkbox]').prop('checked', false);
      toggleUncheckAll.html('Check all');
    }
    else {
      continueForm.find('input[type=checkbox]').prop('checked', true);
      toggleUncheckAll.html('Uncheck all');
    }
    allChecked = !allChecked;
  });
  
  continueForm.on('submit', () => {
    continueButton.html(`
      <i class="fa fa-circle-o-notch spinning"></i>
      Continue
    `);
    scanAgainButton.attr('disabled', 'disabled');
  });

  scanAgainForm.on('submit', () => {
    continueButton.attr('disabled', 'disabled');
    scanAgainButton.find('.scan-progress-indicator')
      .removeClass('fa-search')
      .addClass('fa-circle-o-notch')
      .addClass('spinning');
    scanAgainButton.find('.text').text('Scanning');
  });
}
