// @flow
import $ from 'jquery';

import * as xhr from 'codescene-ui/src/browser/xhr';
import * as tabulator from 'codescene-ui/src/tabulator';

import * as tableSorter from 'codescene-ui/src/table-sorter';

type ViewOptions = {
  fileSummaryUrl : string
};

function parseFileSummaryRow(row) {
  return {
    language: row.language,
    files: parseInt(row.files).toLocaleString(),
    blank: parseInt(row.blank).toLocaleString(),
    comment: parseInt(row.comment).toLocaleString(),
    code: parseInt(row.code).toLocaleString(),
  };
}

export function init(options : ViewOptions) {
  const fileSummaryContainer = $('#filecontent');

  xhr.csv(options.fileSummaryUrl, parseFileSummaryRow)
    .then(data => {
      const fileTable = tabulator.tabulate(fileSummaryContainer.get(0), data, ['language', 'files', 'blank', 'comment', 'code']);

      fileTable
        .attr('id', 'summarytable')
        .classed('file-content', true)
        .selectAll('thead th')
        .text(function(column) {
          return column.charAt(0).toUpperCase() + column.substr(1);
        });

      tableSorter.sort($(fileTable.node()));
    });
}
