// @flow
import $ from 'jquery';

import * as xhr from 'codescene-ui/src/browser/xhr';
import * as tabulator from 'codescene-ui/src/tabulator';
import * as tableSorter from 'codescene-ui/src/table-sorter';

type ViewOptions = {
  authorsUrl : string
};

function renderTable(container : $, data : Array<any>) {
  var table = tabulator.tabulate(container.get(0), data, ['author','lastcontrib'])
    .attr('id', 'authors-table')
    .classed('table-hover', true);

  // better names for the columns
  table.selectAll('thead th')
    .text(function(column, i) {
      if (i === 0) {
        return 'Author';
      }
      else if (i === 1) {
        return 'Date of Last Contribution';
      }
      return column;
    });

  // Wrap module names in anchor and code element:
  table.selectAll('td.column-name')
    .html(function (d) { return '<code>' + d.value + '</code>';});

  tableSorter.sort($(table.node()), {});
}

export function init(options : ViewOptions) {
  const container = $('#tableview');
  xhr.csv(options.authorsUrl)
    .then(data => {
      renderTable(container, data);
    });
}
