-- name: activity-by-project-id
-- Retrieves date of the last recorded access for the given project.
select project_id, last_access_date from project_activity WHERE project_id = ?;

-- name: all-activities
-- Retrieves date of the last recorded access for the given project.
select project_id, last_access_date from project_activity;

-- name: insert-activity-for-project!
-- Inserts an activity record for the given project.
insert into project_activity (project_id, last_access_date) values(:project_id, :last_access_date);

-- name: update-activity!
-- Invoked once a project has been accessed to record time of access..
update project_activity
  set last_access_date = :last_access_date
       where project_id = ?;

-- name: delete-all-activities!
delete from project_activity;
