// Find average of data
function findAverageAtSite(site) {
  // Fetch data measurements from the server
  const measurements = fetchMeasurements();

  const samples = [];

  // Find all samples for the given site
  for (const measurement of measurements) {
    if (measurement.site === site) {
      samples = samples.concat(measurement.samples);
    }
  }

  // Compute the average of all samples and filter outliers
  let sum = 0;
  for (const sample of samples) {
    if (isOutlier(sample)) {
      continue;
    }
    sum += sample;
  }

  return sum / samples.length;
}
