// Compiled by ClojureScript 1.11.4 {:optimizations :none}
goog.provide('same.ish');
goog.require('cljs.core');
goog.require('same.compare');
goog.require('same.platform');
/**
 * The default comparator. Stored in a separate var to make it easier to reset after
 *   modifying with [[set-comparator!]]
 */
same.ish.default_comparator = same.compare.compare_ulp.call(null,100.0,(2));
/**
 * The function for comparing individual floats/doubles.
 *   Can be overridden using [[with-comparator]] or [[set-comparator!]].
 */
same.ish._STAR_comparator_STAR_ = same.ish.default_comparator;
/**
 * Split a collection into a vector of floating point values (of type Float or Double),
 *   and a set of all other values.
 */
same.ish.split_floats = (function same$ish$split_floats(coll){
return cljs.core.reduce.call(null,(function (p__8828,v){
var vec__8829 = p__8828;
var floats = cljs.core.nth.call(null,vec__8829,(0),null);
var rest = cljs.core.nth.call(null,vec__8829,(1),null);
if(cljs.core.float_QMARK_.call(null,v)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,floats,v),rest], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [floats,cljs.core.conj.call(null,rest,v)], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),coll);
});

/**
 * Protocol for approximately comparing any types (using [[*comparator*]] for floating point parts).
 * @interface
 */
same.ish.Approximate = function(){};

var same$ish$Approximate$ish$dyn_8832 = (function (this$,that){
var x__4550__auto__ = (((this$ == null))?null:this$);
var m__4551__auto__ = (same.ish.ish[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,this$,that);
} else {
var m__4549__auto__ = (same.ish.ish["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,this$,that);
} else {
throw cljs.core.missing_protocol.call(null,"Approximate.ish",this$);
}
}
});
/**
 * Return true if the two arguments are approximately equal.
 */
same.ish.ish = (function same$ish$ish(this$,that){
if((((!((this$ == null)))) && ((!((this$.same$ish$Approximate$ish$arity$2 == null)))))){
return this$.same$ish$Approximate$ish$arity$2(this$,that);
} else {
return same$ish$Approximate$ish$dyn_8832.call(null,this$,that);
}
});

(same.ish.Approximate["null"] = true);

(same.ish.ish["null"] = (function (_this,that){
return (that == null);
}));

(same.ish.Approximate["number"] = true);

(same.ish.ish["number"] = (function (this$,that){
if(typeof that === 'number'){
return same.ish._STAR_comparator_STAR_.call(null,this$,that);
} else {
return cljs.core._EQ_.call(null,this$,that);
}
}));

(same.ish.Approximate["boolean"] = true);

(same.ish.ish["boolean"] = (function (this$,that){
return cljs.core._EQ_.call(null,this$,that);
}));

(same.ish.Approximate["array"] = true);

(same.ish.ish["array"] = (function (this$,that){
return ((same.platform.is_array_QMARK_.call(null,that)) && (((cljs.core._EQ_.call(null,cljs.core.count.call(null,this$),cljs.core.count.call(null,that))) && (cljs.core.every_QMARK_.call(null,cljs.core.identity,cljs.core.map.call(null,same.ish.ish,this$,that))))));
}));

(same.ish.Approximate["string"] = true);

(same.ish.ish["string"] = (function (this$,that){
return cljs.core._EQ_.call(null,this$,that);
}));

(same.ish.Approximate["object"] = true);

(same.ish.ish["object"] = (function (this$,that){
if(cljs.core._EQ_.call(null,this$,that)){
return true;
} else {
if(((cljs.core.sequential_QMARK_.call(null,this$)) && (cljs.core.sequential_QMARK_.call(null,that)))){
return ((cljs.core._EQ_.call(null,cljs.core.count.call(null,this$),cljs.core.count.call(null,that))) && (cljs.core.every_QMARK_.call(null,cljs.core.partial.call(null,cljs.core.apply,same.ish.ish),cljs.core.map.call(null,cljs.core.vector,this$,that))));
} else {
if(((cljs.core.map_QMARK_.call(null,this$)) && (cljs.core.map_QMARK_.call(null,that)))){
var and__4251__auto__ = cljs.core._EQ_.call(null,cljs.core.count.call(null,this$),cljs.core.count.call(null,that));
if(and__4251__auto__){
var vec__8839 = same.ish.split_floats.call(null,cljs.core.keys.call(null,this$));
var this_floats = cljs.core.nth.call(null,vec__8839,(0),null);
var this_rest = cljs.core.nth.call(null,vec__8839,(1),null);
var vec__8842 = same.ish.split_floats.call(null,cljs.core.keys.call(null,that));
var that_floats = cljs.core.nth.call(null,vec__8842,(0),null);
var that_rest = cljs.core.nth.call(null,vec__8842,(1),null);
return ((cljs.core._EQ_.call(null,this_rest,that_rest)) && (((cljs.core.every_QMARK_.call(null,(function (p1__8836_SHARP_){
return same.ish.ish.call(null,cljs.core.get.call(null,this$,p1__8836_SHARP_),cljs.core.get.call(null,that,p1__8836_SHARP_));
}),this_rest)) && (cljs.core.every_QMARK_.call(null,cljs.core.identity,cljs.core.map.call(null,(function (p1__8837_SHARP_,p2__8838_SHARP_){
var and__4251__auto____$3 = same.ish.ish.call(null,p1__8837_SHARP_,p2__8838_SHARP_);
if(cljs.core.truth_(and__4251__auto____$3)){
return same.ish.ish.call(null,cljs.core.get.call(null,this$,p1__8837_SHARP_),cljs.core.get.call(null,that,p2__8838_SHARP_));
} else {
return and__4251__auto____$3;
}
}),cljs.core.sort.call(null,this_floats),cljs.core.sort.call(null,that_floats)))))));
} else {
return and__4251__auto__;
}
} else {
if(((cljs.core.set_QMARK_.call(null,this$)) && (cljs.core.set_QMARK_.call(null,that)))){
var and__4251__auto__ = cljs.core._EQ_.call(null,cljs.core.count.call(null,this$),cljs.core.count.call(null,that));
if(and__4251__auto__){
var vec__8845 = same.ish.split_floats.call(null,this$);
var this_floats = cljs.core.nth.call(null,vec__8845,(0),null);
var this_rest = cljs.core.nth.call(null,vec__8845,(1),null);
var vec__8848 = same.ish.split_floats.call(null,that);
var that_floats = cljs.core.nth.call(null,vec__8848,(0),null);
var that_rest = cljs.core.nth.call(null,vec__8848,(1),null);
var and__4251__auto____$1 = cljs.core._EQ_.call(null,this_rest,that_rest);
if(and__4251__auto____$1){
return same.ish.ish.call(null,cljs.core.sort.call(null,this_floats),cljs.core.sort.call(null,that_floats));
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
} else {
return false;

}
}
}
}
}));

//# sourceMappingURL=ish.js.map
