grammar Terraform;
options {superClass=hotspots_x_ray.languages.InterruptibleParser;}

// Entry point for X-Ray and function based metrics:
//
translationunit
:
	expression* EOF
;

// Entry point for cyclomatic complexity:
//
cyclomatic_complexity
:
	cyclomatic_complexity_expressions* EOF
;

cyclomatic_complexity_expressions : complexity
                                  | complexity_anything;

complexity: loops | conditionals;
complexity_anything: .;

loops: FOR | FOR_EACH | splat_expression;
splat_expression: '[' '*' ']' '.';
conditionals: IF | ternary_operator | LOGICAL_AND | LOGICAL_OR;
ternary_operator: '?';

expression: block
          | anything;

anything : ~(LeftBrace | RightBrace);

block: type labels block_body;

type: ID;

labels: label*;

label: STRING;

block_body: LeftBrace block_body_expr*? RightBrace;

block_body_expr: anything | nested_block;

nested_block: LeftBrace block_body_expr*? RightBrace;

fragment ESCAPED : '\\\\' | '\\"';
STRING : '"' ( ESCAPED | ~('\n'|'\r') )*? '"';

Whitespace : [ \t]+ -> skip;

BlockComment: '/*' .*? '*/' -> skip;
LineComment: '//' ~[\r\n]* -> skip;
AlternateLineComment: '#' ~[\r\n]* -> skip;

NEWLINE : '\r'? '\n' -> skip;

FOR_EACH: 'for_each';
FOR: 'for';
IF: 'if';
LOGICAL_AND: '&&';
LOGICAL_OR: '||';

ID : [a-zA-Z_\-][a-zA-Z0-9_\-]*;

SCOPER : '.';
SCOPED_NAME : ID (SCOPER ID)+;

LeftBrace: '{';
RightBrace: '}';

ANY_CHAR : .; // Put this lexer rule last to give it the lowest precedence
