grammar SwiftComplexity;
options {superClass=hotspots_x_ray.languages.InterruptibleParser;}

method
:
	expression* EOF
;

expression : complexity
           | anything;

complexity: loops | paths | conditionals;
anything: .;

loops: FOR | WHILE;

paths: CATCH | THROW;

conditionals: IF | FOR | CASE | OPERATORS;

fragment ESCAPED : '\\\\' | '\\"';
LITERAL : '"' ( ESCAPED | ~('\n'|'\r') )*? '"';

SINGLE_LITERAL : '\''  ~('\n'|'\r')*? '\'';

BACK_QUOTED : '`'  ~('\n'|'\r')*? '`';

LITERAL_CHAR : '\'' . '\'' -> skip;

IF: 'if';
FOR: 'for';
WHILE: 'while'; // Covers repeat...while too
CASE: 'case';
CATCH: 'catch';
THROW: 'throw';
RETURN: 'return';

OPERATORS: '&&' | '||';

LEFT_PAREN: '(';
COLON: ':';
SEMICOLON: ';';

Whitespace : [ \t]+ -> skip;

BlockComment: '/*' .*? '*/' -> skip;
LineComment: '//' ~[\r\n]* -> skip;

NEWLINE : '\r'? '\n' -> skip;

ID : [a-zA-Z_][a-zA-Z0-9_]*;

ANY_CHAR : .; // Put this lexer rule last to give it the lowest precedence
