grammar Scala;
options {superClass=hotspots_x_ray.languages.InterruptibleParser;}

import ScalaSharedRulesLexer;

translationunit
:
	expression* EOF
;

// classes, objects
expression : top_level_method_scope
           | function_declaration
           | test_fw_method
           | top_level_block_statement
           | import_scala_test
           | member_variable
           | anything;

member_variable: (VAL | VAR) member_variable_name;
member_variable_name: id_name;

// we want to get rid of traits and stuff when we parse unit tests, otherwise
// we risk a too greedy parse. Example:
// "authenticated" >> {
//    trait AuthenticatedRequest extends Request with AuthenticatedServerRequest
//
//    "should return 200" in new AuthenticatedRequest {
//       result.status must beEqualTo(200)
//     }
test_expression : test_trait
                | function_declaration
                | test_fw_method
                | top_level_block_statement
                | anything;

test_trait: TRAIT class_name ('extends' class_name)? ('with' class_name);

// Scala tests aren't partitioned in real functions. We detect if the unit it scalatest with the following rule:
import_scala_test: IMPORT (SCALA_TEST | ~(IMPORT | CLASS | LeftBrace)*? SPEC2_TEST);

top_level_block_statement : LeftBrace expression* RightBrace;

top_level_method_scope : (CLASS | OBJECT | TRAIT) class_name constructor_params? ~(LeftBrace | DEF)*? LeftBrace expression* RightBrace;
class_name : id_name;

constructor_params: LeftParen constructor_member_variable_list? ','? RightParen; // allow superflouous comma

constructor_member_variable_list: constructor_member_variable
                                 | constructor_member_variable ',' constructor_member_variable_list;
constructor_member_variable: (VAL | VAR)? member_variable_name ':' ~(',' | RightParen)*?;

test_fw_method: spec2_group
              | scala_test_spec
              | bdd_describe
              | bdd_scenario
              | plain_test;

spec2_group: spec2_group_name GREATER_GREATER LeftBrace test_expression* RightBrace;
spec2_group_name: LITERAL;

bdd_describe: (DESCRIBE | FEATURE) LeftParen bdd_description_name RightParen LeftBrace test_expression*? RightBrace;
bdd_description_name: LITERAL;

bdd_scenario: (IT | SCENARIO) LeftParen bdd_scenario_name RightParen LeftBrace function_body RightBrace;
bdd_scenario_name: LITERAL;

plain_test: (TEST | IGNORE) LeftParen plain_test_name RightParen LeftBrace function_body RightBrace;
plain_test_name: LITERAL;

scala_test_spec: test_description IN test_object_creation? LeftBrace function_body RightBrace;
test_description: (IT | SHOULD | ID_WORD | LITERAL | INT)+;
test_object_creation: 'new' ~(LeftBrace)+?;

function_declaration : DEF function_name generic_signature? function_args?
                       function_return_signature?
                       (function_paren_wrapped
                        |
                        ('='? function_body_expression_block
                             function_body_block?
                             following_function_body_block?)
                        | function_body_block);

// def formatExplain(pairs: (String, Any)*): String = ( ... )
function_paren_wrapped: '=' LeftParen function_paren_wrapped_body+ RightParen ('match' function_body_block)?;

function_paren_wrapped_body: ~(LeftParen | RightParen)
                           | LeftParen function_paren_wrapped_body*? RightParen;

function_body_expression_block: function_body_expression+;

function_args : LeftParen function_definition_params_list? RightParen;

function_definition_params_list : function_param
                                | function_definition_params_list ',' function_param
                                ;

function_param: ~(LeftParen | RightParen)+?;

// --
anything : ~(LeftBrace | RightBrace);

id_name: ID_WORD | ID_SPECIAL;

function_name : id_name;

generic_signature : '[' ~(']' | LeftBrace)*? ']';

function_return_signature :  ~('=' | LeftBrace | DEF)* ':' ~(LeftBrace | '=' | DEF)+;

function_body_block : fn_body_block_content+
                   ;

// e.g. finally {... }
following_function_body_block: following_function_body_expressions*? function_body_block;
following_function_body_expressions: ('if' | 'if' 'else' | 'else' | 'finally') function_body_expression*?;

fn_body_block_content : LeftBrace function_body RightBrace
                     | LeftParen fn_body_block_content function_body_expression? RightParen;

function_body_expression : ~(DEF | LeftBrace | RightBrace | 'protected' | 'implicit' |
                                    'private' | 'public' | 'lazy' | 'val' | 'var' | '@' | FINAL |
                                    'sealed' | 'abstract' | 'override' | 'import' | CLASS | OBJECT | TRAIT);

function_body : function_body_statement*;

function_body_statement : block_statement
                        | any_function_statement;

block_statement : LeftBrace function_body_statement*? RightBrace;

any_function_statement : ~(LeftBrace | RightBrace);
