grammar Perl;

import PerlSharedRulesLexer;

translationunit
:
	expression* EOF
;

expression : function_declaration
           | global_variable
           | scoped_variable
           | top_level_block_statement
           | anything;

anything : ~(LeftBrace | RightBrace);

global_variable: OUR ('%' | '@' | '$') global_variable_name (ASSIGN | ';');
global_variable_name: ID;

top_level_block_statement : LeftBrace (scoped_variable | top_level_block_statement | anything)*? RightBrace;

function_declaration : SUB function_name optional_arguments_list? function_scope;

function_name: ID;

function_scope: LeftBrace function_body RightBrace;

optional_arguments_list: LeftParen function_definition_params_list? RightParen;
function_definition_params_list : function_param
                                | function_definition_params_list ',' function_param
                                ;
function_param: ~(',' | RightParen)+?;

function_body : function_body_statement*?;

function_body_statement : scoped_variable
                        | block_statement
                        | arguments
                        | anything;

scoped_variable: LeftBrace ID RightBrace;

block_statement : LeftBrace function_body_statement*? RightBrace;

arguments: list_args | indexed_args;

list_args: 'my' LeftParen? argument_list RightParen? '=' ALL_ARGS_ALIAS;

argument_list: one_arg
             | argument_list ',' one_arg;

one_arg: ('%' | '@' | '$') ID;

indexed_args: one_arg '=' ONE_ARG_ALIAS;


