lexer grammar PHPSharedRulesLexer;

fragment ESCAPED : '\\\\' | '\\"';
LITERAL : '"' ( ESCAPED | ~('\n'|'\r') )*? '"';

SINGLE_LITERAL : '\''  ~('\n'|'\r')*? '\'';

fragment ESCAPED_SLASH : '\\/';
REGEX : '/' (ESCAPED_SLASH | ~('\n'|'\r') )*? '/';

LITERAL_CHAR : '\'' . '\'' -> skip;

NEWLINE : '\r'? '\n' -> skip;

FUNCTION: 'function';
CLASS: 'class';

COLON: ':';

LeftParen : '(';
RightParen: ')';

LeftBrace : '{';
RightBrace : '}';

SEMICOLON : ';';

TRIPLE_DOTS: '...';
COMMA: ',';

COMPARISON: '==';
ASSIGN: '=';

Whitespace : [ \t]+ -> skip;

BlockComment: '/*' .*? '*/' -> skip;
LineComment: '//' ~[\r\n]* -> skip;

PARAMETER_NAME : [&$]+[a-zA-Z_][a-zA-Z0-9_]*;

IF: 'if';
ELSEIF: 'elseif';
ELSE: 'else';
ENDIF: 'endif';
FOR: 'for';
FOREACH: 'foreach';
ENDFOR: 'endfor';
ENDFOREACH: 'endforeach';
AS: 'as';
DO: 'do';
WHILE: 'while';
ENDWHILE: 'endwhile';
SWITCH: 'switch';
ENDSWITCH: 'endswitch';
CASE: 'case';
CATCH: 'catch';
THROW: 'throw';
RETURN: 'return';
GOTO: 'goto';

OPERATORS: '&&' | '||';

ID : [a-zA-Z_][a-zA-Z0-9_]*;
SCOPER : '.';
SCOPED_NAME : ID (SCOPER ID)+;

INT : [0-9]+;

ANY_CHAR : .; // Put this lexer rule last to give it the lowest precedence