grammar JavaSharedRulesParser;

import JavaSharedRulesLexer;

anything : ~(LeftBrace | RightBrace | CLASS);

class_name : ID;

interface_name : ID;

function_declaration : function_prelude? function_name LeftParen function_definition_params_list? RightParen throw_spec? LeftBrace function_body RightBrace;
// - C'tors don't have any prelude
// - The access modifier (private, public, etc.) is optional in Java and defaults to 'protected'.
function_prelude: function_access_modifier? non_access_modifier? function_prelude_annotation return_type;

function_access_modifier: PUBLIC | PRIVATE | PROTECTED;
non_access_modifier: FINAL | STATIC | ABSTRACT
                   | TRANSIENT | SYNCHRONIZED | VOLATILE;

// This is where Java syntax becomes complicated:
// -- static <T> void
return_type: generic_type? type_name generic_type?; // Document vs Document<SomeType>

function_prelude_annotation: type_use_annotation? annotation*;

// Java annotations, e.g. <@NonNull T> or @NonNull
annotation: annotation_id annotation_arg_list?;
annotation_id: AT_SIGN  (ID | SCOPED_NAME);

// Generic types can have a type-use annotation which specifies
// constraints on any use of the type.
// Example:
//  public <@NonNull @Size(max = 10) T, @NonNull U> void process(T input1, U input2) {
//    Method implementation...
//  }
//
// The relevant part of the syntax is:
//   <@NonNull T, @NonNull U>
type_use_annotation: '<' type_use_annotation_parts '>';
type_use_annotation_parts: type_use_annotation_part
                          | type_use_annotation_parts ',' type_use_annotation_part;
type_use_annotation_part: annotation type_name;

function_name : (ID | SCOPED_NAME);

exception : ID | SCOPED_NAME;
throw_spec : THROWS annotation? exception
           | throw_spec (',' exception)+;

fun_arg : annotation* 'final'? (generic_args | parameter);

// Annotations can have arguments: @Size(max = 10)
annotation_arg_list: LeftParen decorator_parameters RightParen;

decorator_parameters : decorator_parameter
                     | decorator_parameters ',' decorator_parameter;
decorator_parameter: annotation_arg_constraint_value
                   | SCOPED_NAME
                   | ID
                   | LITERAL;
annotation_arg_constraint_value: ID '=' decorator_parameter_value;
decorator_parameter_value: annotation
                         | ~(',' | RightParen | LeftParen)*?
                         | LeftParen decorator_parameter_value RightParen
                         | LeftBrace ~(RightBrace)*? RightBrace; // e.g. sort = {"stage", "order.orderNumber"}

type_name: (ID | SCOPED_NAME) '[]'*;

generic_args: type_name generic_type
              vararg? // e.g. MapResult<?, ?>... results
              argument_name;
generic_type: '<' generic_arg_list '>';
generic_arg: ~('<' | '>')*? generic_type?;
generic_arg_list: generic_arg
                 | generic_arg_list ',' generic_arg;

argument_type: type_name vararg?; // eg. String... couldBeManyStrings
vararg: '...';
parameter: argument_type argument_name;
argument_name: ID;

function_definition_params_list : fun_arg
                                | function_definition_params_list ',' fun_arg;

function_body : function_body_statement*?;

function_body_statement : block_statement
                        | any_statement;

block_statement : LeftBrace function_body_statement*? RightBrace;

any_statement : ~(LeftBrace | RightBrace);

