grammar JavaMicro;

import JavaSharedRulesParser;

translationunit
:
	expression* EOF
;

expression : class_declaration
           | interface_declaration
           | record_declaration
           | property_with_object_initialization
           | function_declaration
           | block_statement
           | anything;

// Note that enumerations can contain methods too...
class_declaration : (CLASS | ENUM) class_name ~LeftBrace*? LeftBrace expression*? RightBrace;
interface_declaration : INTERFACE interface_name ~LeftBrace*? LeftBrace expression*? RightBrace;

// e.g. public record Person (String name, String address) {}
record_declaration : RECORD class_name record_declaration_arguments ~LeftBrace*? LeftBrace expression*? RightBrace;
record_declaration_arguments: LeftParen function_definition_params_list? RightParen;

property_with_object_initialization : '=' 'new'  (ID | SCOPED_NAME) LeftParen function_definition_params_list? RightParen LeftBrace expression+ RightBrace;

