grammar Groovy;

import GroovySharedRulesParser;

translationunit
:
	expression* EOF
;

expression : class_declaration
           | property_with_object_initialization
           | function_declaration
           | block_statement
           | anything;

class_declaration : (CLASS | TRAIT) class_name ~LeftBrace*? LeftBrace expression*? RightBrace;
class_name : ID;

property_with_object_initialization : '=' 'new'  (ID | SCOPED_NAME) LeftParen function_definition_params_list? RightParen LeftBrace expression+ RightBrace;

function_declaration : function_name LeftParen function_definition_params_list? RightParen throw_spec? LeftBrace function_body RightBrace;

function_definition_params_list : function_param
                                | function_definition_params_list ',' function_param
                                | function_param+
                                ;

function_param: ~(',' | LeftParen | RightParen)+?;
