lexer grammar GoSharedRulesLexer;

fragment ESCAPED : '\\\\' | '\\"';
LITERAL : '"' ( ESCAPED | ~('\n'|'\r') )*? '"';

SINGLE_LITERAL : '\''  ~('\n'|'\r')*? '\'';

BACK_QUOTED : '`'  ~('\n'|'\r')*? '`';

LITERAL_CHAR : '\'' . '\'' -> skip;

FUNCTION: 'func';

EMPTY_INTERFACE: 'interface' '{' '}';

LeftParen : '(';
RightParen: ')';

LeftBrace : '{';
RightBrace : '}';

LeftBracket: '[';
RightBracket: ']';

Whitespace : [ \t]+ -> skip;

BlockComment: '/*' .*? '*/' -> skip;
LineComment: '//' ~[\r\n]* -> skip;

NEWLINE : '\r'? '\n' -> skip;

VAR: 'var';
VAR_SHORTCUT: ':=';
CONST: 'const';

// Control structures
FOR: 'for';
IF: 'if';
ELSE: 'else';
SWITCH: 'switch';
CASE: 'case';
AND: '&&';
OR: '||';
RETURN: 'return';

ID : [a-zA-Z_][a-zA-Z0-9_]*;
INTEGER: [0-9]+;

ANY_CHAR : .; // Put this lexer rule last to give it the lowest precedence