grammar EcmaScriptConsecutiveAssertions;

singlefunctionscope
:
	expression* EOF
;

expression : assertion_blocks
           | .;

assertion_blocks: assertion_statement+;

assertion_statement: node_test
                   | node_assert
                   | mocha_assert
                   | chai_assert;

node_test: TEST (DOT ASSERT_TYPE mocha_assert_condition?)+ SEMICOLON?;

// Node
node_assert: (TEST DOT)? ASSERT (DOT ASSERT_TYPE)? mocha_assert_condition SEMICOLON?;

// Mocha
mocha_assert: ASSERT DOT ASSERT_TYPE mocha_assert_condition SEMICOLON?;

mocha_assert_condition: LEFT_BRACE mocha_assert_parts*? RIGHT_BRACE;

mocha_assert_parts: ~(LEFT_BRACE | RIGHT_BRACE | ASSERT)
                  | LEFT_BRACE mocha_assert_parts RIGHT_BRACE;

// NOTE: Chai would be too complex without relaying on the terminating SEMICOLON, so let's
// simplify it for now:
chai_assert: EXPECT chai_assert_condition ~(LEFT_BRACE | RIGHT_BRACE | EXPECT | SEMICOLON)*? SEMICOLON;

chai_assert_condition: LEFT_BRACE chai_assert_parts+ RIGHT_BRACE;

chai_assert_parts: ~(LEFT_BRACE | RIGHT_BRACE | EXPECT)
                  | LEFT_BRACE chai_assert_parts RIGHT_BRACE;

ASSERT: 'assert';
EXPECT: 'expect';
SHOULD: 'should';
TEST: 'test';
ASSERT_TYPE : [a-zA-Z_][a-zA-Z0-9]*;
DOT: '.';

LEFT_BRACE: '(';
RIGHT_BRACE: ')';
SEMICOLON : ';';

fragment ESCAPED : '\\\\' | '\\"';
LITERAL : '"' ( ESCAPED | ~('\n'|'\r') )*? '"';

fragment ESCAPED_SINGLE : '\\\\' | '\\\'';
SINGLE_LITERAL : '\'' (ESCAPED_SINGLE | ~('\n'|'\r') )*? '\'';

// Note: there's a nasty trap here that we fixed with the ~'>' rule.
// Without this rule, we would fail to close the block in the following kind of expression:
//    <Flex grow={1}>{systemId && <BadgeEntity systemId={systemId} size="sm" /> } </Flex>
fragment ESCAPED_SLASH : '\\/';
REGEX : '/' ~'>' (ESCAPED_SLASH | ~('\n'|'\r') )*? '/';

fragment ESCAPED_BACKTICK : '\\`';
BACKTICK_TEMPLATE : '`' ( ESCAPED_BACKTICK | ~('\n'|'\r') )*? '`';

LITERAL_CHAR : '\'' . '\'' -> skip;

Whitespace : [ \t]+ -> skip;

BlockComment: '/*' .*? '*/' -> skip;
LineComment: '//' ~[\r\n]* -> skip;

NEWLINE : '\r'? '\n' -> skip;

ANY_CHAR: .;