grammar ECMAScriptComplexity;

method
:
	expression* EOF
;

expression : complexity
           | anything;

complexity: loops | paths | conditionals;
anything: .;

loops: leading_sequence (FOR | WHILE) Whitespace? LEFT_PAREN;

paths: (CATCH Whitespace? LEFT_PAREN) |
       (THROW Whitespace);

conditionals: (leading_sequence (IF Whitespace? LEFT_PAREN) |
                                (CASE Whitespace))
              | OPERATORS;

leading_sequence: Whitespace | NEWLINE;

fragment ESCAPED : '\\\\' | '\\"';
LITERAL : '"' ( ESCAPED | ~('\n'|'\r') )*? '"';

fragment ESCAPED_SINGLE : '\\\\' | '\\\'';
SINGLE_LITERAL : '\'' (ESCAPED_SINGLE | ~('\n'|'\r') )*? '\'';

// Note: there's a nasty trap here that we fixed with the ~'>' rule.
// Without this rule, we would fail to close the block in the following kind of expression:
//    <Flex grow={1}>{systemId && <BadgeEntity systemId={systemId} size="sm" /> } </Flex>
fragment ESCAPED_SLASH : '\\/';
REGEX : '/' ~'>' (ESCAPED_SLASH | ~('\n'|'\r') )*? '/';

fragment ESCAPED_BACKTICK : '\\`';
BACKTICK_TEMPLATE : '`' ( ESCAPED_BACKTICK | ~('`') )*? '`';


LITERAL_CHAR : '\'' . '\'' -> skip;

IF: 'if';

TYPE_SCRIPT_UNDEFINED: '?:';

NULL_COALESCING: '??';

OPERATORS: NULL_COALESCING | '&&' | '||' | '?';

CASE: 'case';

FOR: 'for';
WHILE: 'while';

CATCH: 'catch';
THROW: 'throw';

RETURN: 'return';

LEFT_PAREN: '(';
COLON: ':';
SEMICOLON: ';';

Whitespace : [ \t]+;

BlockComment: '/*' .*? '*/' -> skip;
LineComment: '//' ~[\r\n]* -> skip;

NEWLINE : '\r'? '\n';

ANY_CHAR : .; // Put this lexer rule last to give it the lowest precedence