(ns codescene.features.time-series.core
  (:require
   [clj-time.coerce :as tcoerce]
   [clj-time.format :as f]
   [clojure.string :as str]
   [codescene.features.time-series.time-series-db :as time-series-db]))


(defn entries-in-range-json
  "Returns a json string with all the time series entries for the given
  `range`.  For details about the `range`, see
  `time-series-dispatch-on-range` in `time-series-db`."
  [db-spec project-id time-series range]
  (->>
    (time-series-db/get-time-series-for-range db-spec time-series project-id range)
    (str/join ", ")
    (format "[%s]")))

(defn to-json-date
  [timestamp]
  (f/unparse (:date-hour-minute-second-fraction f/formatters) (tcoerce/to-date-time timestamp)))

