(ns codescene.features.reports.report-types)

;; Kept for backwards compatibility with onprem
(def deprecated-project-report-types [])

(def legacy-project [{:type (name :technical-health-overview) :name "Technical Health Overview"}
                     {:type (name :trend-report) :name "Trend & Alerts"}
                     {:type (name :key-personnel-and-knowledge-distribution) :name "Key Personnel and Knowledge Distribution"}])

(def project [{:type (name :code-health-overview) :name "Code Health Overview"}])

(def account [{:type (name :software-portfolio-overview) :name "Software Portfolio Overview"}])

(def all (concat project account))

(def valid-reports (->> (concat project account legacy-project)
                        (map :type)
                        (map keyword)
                        set))

(defn is-standard-report? [type]
  (some #{type} (map #(keyword (:type %)) all)))

(defn is-legacy-project-report? [type]
  (some #{type} (map #(keyword (:type %)) legacy-project)))

(defn is-account-report? [type]
  (some #{type} (map #(keyword (:type %)) account)))

(defn is-supported-type? [type]
  (contains? valid-reports type))

(defn type->name [report-type]
  (or (->> all
           (map #(hash-map (keyword (:type %)) (:name %)))
           (apply merge)
           report-type)
      (name report-type)))

(comment
  (type->name :management)
  (type->name :key-personnel-and-knowledge-distribution)
  (type->name :cake-bake)
  (type->name :code-health-overview)
  (type->name :product-portfolio-overview))

