(ns codescene.features.pm-data.gitlab.cache
  "Wraps some fetcher fns to make them cacheable"
  (:require [codescene.features.pm-data.gitlab.fetcher :as f]
            [codescene.features.pm-data.cache :as cache]
            [codescene.url.url-utils :as url]))

(def ^:private cached-data-version 1)

(defn- fetch-merge-requests-key-fn
  [_ _ {:keys [host owner-login repo-slug]}]
  [host owner-login repo-slug cached-data-version])

(def ^:private fetch-merge-requests-cacheable (cache/make-cacheable f/fetch-merge-requests))
(cache/memo #'fetch-merge-requests-cacheable fetch-merge-requests-key-fn)

(defn fetch-merge-requests
  [since authed-client repo-info]
  (cache/combine-with-cache fetch-merge-requests-cacheable fetch-merge-requests-key-fn 
                            since authed-client repo-info))

(defn- fetch-issues-key-fn
  [_ _ repo-url {:keys [] :as _provider-def}]
  repo-url)

(def ^:private fetch-issues-cacheable (cache/make-cacheable f/fetch-issues))
(cache/memo #'fetch-issues-cacheable fetch-issues-key-fn)

(defn fetch-issues
  [since api-client repo-url provider-def]
  (cache/combine-with-cache fetch-issues-cacheable fetch-issues-key-fn
                            since api-client repo-url provider-def))

(comment
  (def authed-client (System/getenv "GITLAB_TOKEN"))
  (def repo-info (codescene.url.url-utils/repo-url->repo-info "git@gitlab.com:empear/analysis-target.git" :gitlab false))
  (let [since (evolutionary-metrics.trends.dates/string->date "2021-01-22")]
    (codescene.cache.core/with-file-cache "." "." :pm-data
      {:fetch-merge-requests (count (fetch-merge-requests since authed-client repo-info))})))
