(ns codescene.features.pm-data.github.github-api
  "Contains methods for fetching data over the GitHub Rest API.
   Queries and paging but nothing more is handled here, with the requested json data returned as clojure collections"
  (:require [clj-http.links :refer [read-link-headers]]
            [codescene.features.repository-provider.github.api :as github-api]
            [codescene.features.util.http-helpers :as h]))

(def ^:const inertia-preview "application/vnd.github.inertia-preview+json")

(defn- links-response
  [response]
  (if-let [link-headers (get-in response [:headers "Link"])]
    (let [link-headers (if (coll? link-headers)
                         link-headers
                         [link-headers])]
      (assoc response
        :links
        (into {} (map read-link-headers link-headers))))
    response))

(defn get-data*
  [api-client url query-params]
  (let [result (github-api/api-request* api-client :get url
                                        {:query-params   query-params
                                         :accept         inertia-preview})]
    ;; TODO: clj-http should handle links-response, but for some reason it doesn't work (case?)
    (links-response result)))

(defn get-data
  "Contains methods for fetching data over the GitHub Rest API.
   Queries and paging but nothing more is handled here, with the requested json data returned as clojure collections"
  [api-client url query-params]
  (h/with-http-error-messages (str "Failed to fetch GitHub data from " url)
    (get-data* api-client url query-params)))

(defn fetch-user
  "Fetches information about  user from the remote GitHub API. Throws when the API calls fail."
  [api-client owner]
  (let [url (format "/users/%s" owner)]
    (-> (get-data api-client url {})
        :body)))

(comment
  (def api-token (System/getenv "GITHUB_TOKEN"))
  (def owner "empear-analytics")
  (fetch-user api-token owner)
  )