(ns codescene.features.pm-data.core
  (:require [codescene.features.pm-data.azure.azure-provider]
            [codescene.features.pm-data.azure.pr-data-provider]
            [codescene.features.pm-data.bitbucket.pr-data-provider]
            [codescene.features.pm-data.bitbucket-server.pr-data-provider]
            [codescene.features.pm-data.gitlab.pr-data-provider]
            [codescene.features.pm-data.github.github-provider]
            [codescene.features.pm-data.gitlab.gitlab-provider]
            [codescene.features.pm-data.github.pr-data-provider]
            [codescene.features.pm-data.jira.jira-provider]
            [codescene.features.pm-data.clickup.pm-data-provider]
            [codescene.features.pm-data.pm-data-configuration :as pm-data-configuration]
            [codescene.features.pm-data.pm-data-provider :as features-pm-data-provider]
            [codescene.features.pm-data.provider-def :as provider-def]
            [codescene.features.pm-data.pr-data-provider :as pr-data-provider]
            [codescene.features.pm-data.shortcut.shortcut-provider]
            [codescene.features.pm-data.trello.trello-provider]
            [codescene.features.pm-data.youtrack.youtrack-provider]))

(defn- ->pm-data-context
  ;; There are methods in the providers that will be called multiple times but still use the same external data.
  ;; (Specifically, make-ticket-id-extractor is called for every repo in an analysis, each time using the same fetched data)
  ;; To avoid unnecessary data fetching, an cache is added to the context here.
  ;; The idea is that methods that use external data can make sure the data is fetched only once, and store the data in the cache.
  ;; Note that this means that for one instance of the context, data cannot be "re-fetched"
  [repo-urls]
  {:repo-urls repo-urls})

(defn create-pr-data-provider [provider-def repo-urls]
  (pr-data-provider/create provider-def (->pm-data-context repo-urls)))

(defn validate-pr-data-settings [pr-data-provider]
  (pr-data-provider/validate-settings pr-data-provider))

(defn create-pm-data-provider [provider-def repo-urls]
  (let [pm-data-context (->pm-data-context repo-urls)]
    (features-pm-data-provider/create-pm-data-provider provider-def pm-data-context)))

(defn validate-settings [pm-data-provider]
  (pm-data-configuration/validate-settings pm-data-provider))

(defn get-configuration-data [pm-data-provider]
  (pm-data-configuration/get-configuration-data pm-data-provider))

(defn encrypt [provider-def encryptor]
  (provider-def/encrypt provider-def encryptor))

(defn decrypt [provider-def encryptor]
  (provider-def/decrypt provider-def encryptor))

(defn parse [provider-def]
  (provider-def/parse provider-def))

(defn with-defaults [provider-def config-data]
  (provider-def/with-defaults provider-def config-data))

(defn unparse [provider-def]
  (provider-def/unparse provider-def))
