(ns codescene.features.pm-data.bitbucket.cache
  "Wraps some fetcher fns to make them cacheable"
  (:require [codescene.features.pm-data.bitbucket.fetcher :as bbf]
            [codescene.features.pm-data.cache :as cache]))

(defn- fetch-pull-requests-key-fn
  [_ _ {:keys [host owner-login repo-slug]}]
  [host owner-login repo-slug])

(def ^:private fetch-pull-requests-cacheable (cache/make-cacheable bbf/fetch-pull-requests))
(cache/memo #'fetch-pull-requests-cacheable fetch-pull-requests-key-fn)

(defn fetch-pull-requests
  [since authed-client repo-info]
  (cache/combine-with-cache fetch-pull-requests-cacheable fetch-pull-requests-key-fn 
                            since authed-client repo-info))

(comment
  (def user (System/getenv "BITBUCKET_USER"))
  (def password (System/getenv "BITBUCKET_APP_PASSWORD"))
  (def api-url "https://api.bitbucket.org/2.0")
  (def repo-info (codescene.url.url-utils/repo-url->repo-info  "git@bitbucket.org:empear/analysis-target.git" :bitbucket true))
  (let [since (evolutionary-metrics.trends.dates/string->date "2020-01-22")]
    (codescene.cache.core/with-file-cache "." "." :pm-data
      {:fetch-pull-requests (count (fetch-pull-requests since [user password] repo-info))})))
