(ns codescene.features.delta.integration.pr-check
  (:require [codescene.features.delta.code-health.ch-config :as ch]
            [codescene.features.delta.coverage.cov-config :as cov]
            [codescene.features.delta.integration.integration-config :as ic]
            [codescene.features.delta.integration.integration-db :as integration-db]))

(def onprem-all-props
  (-> (merge-with into ic/onprem-properties ch/provider-properties)
      (update-vals #(into % (concat ic/general-delta-properties ch/every-provider-properties)))))

(def cloud-all-props
  (let [all-providers (concat ch/every-provider-properties ic/general-delta-properties
                              cov/settings-properties)]
    (-> (merge-with into ch/provider-properties cov/properties)
        (update-vals #(into % all-providers)))))

(defn on-prem-hook-config [tx project-id]
  (integration-db/get-config tx project-id onprem-all-props))

(defn cloud-all-config [tx project-id]
  (integration-db/get-config tx project-id cloud-all-props))

(defn enabled? [config-set]
  (or (-> config-set :metadata :ch-enabled?)
      (-> config-set :metadata :cov-enabled?)))