-- :name db-insert-suppression :! :raw
INSERT INTO delta_suppress (project_id, repo_id, file_name, fn_name, biomarker, line, reason, external_review_id, updated_at, suppressed_by)
VALUES (:project_id, :repo_id, :file_name, :fn_name, :biomarker, :line, :reason, :external_review_id, :updated_at, :suppressed_by);

-- :name db-update-suppression :! :n
UPDATE delta_suppress SET
    reason = :reason, suppressed_by = :suppressed_by, line = :line, updated_at = :updated_at
WHERE id = :id;

-- :name db-load-suppressions :? :*
SELECT * from delta_suppress WHERE project_id = :project_id and repo_id = :repo_id order by biomarker, file_name, fn_name

-- :name db-load-suppressions-by-project-id :? :*
SELECT * from delta_suppress WHERE project_id = :project_id order by biomarker, file_name, fn_name

-- :name db-delete-suppression :! :n
DELETE FROM delta_suppress WHERE id = :id
