(ns codescene.features.delta.coverage.cov-gates
  (:require [clojure.java.jdbc :as jdbc]
            [codescene.features.config.presets :as presets]
            [codescene.features.delta.coverage.cov-config :as cov]
            [codescene.features.delta.coverage.pr-check :as pr-check]
            [codescene.features.delta.integration.integration-db :as integration-db]
            [codescene.features.util.maps :refer [map-of]]
            [taoensso.timbre :as log]))

(defn settings-id
  "Returns ID of QG settings stored at scope"
  [db-spec scope]
  (or (get-in (presets/available-settings db-spec scope ["cov-config"]) ["cov-config" 0 :id])
      (presets/create-settings {:db-spec db-spec
                                :scope scope
                                :encryptor identity
                                :params {:category "cov-config"
                                         :label "Code Coverage Quality Gates"
                                         :cov-qg-preset "custom"
                                         :new-and-changed-code? true}
                                :html-form-input? false})))

(def qg-preset-desc
  (integration-db/preset-desc
    "cov-config"
    #(assoc % :qg-preset "global")
    {:qg-preset "custom"
     :new-and-changed-code? true}))

(defn get-project-settings [db-source project scope]
  (jdbc/with-db-transaction [tx (db-source)]
    (let [project-id (:id project)
          {{:keys [exclusion-filter exclude-content whitelist-content
                   code-coverage-exclusions-content] :as _proj} :filters-configuration} project
          {:keys [data] :as config-set} (-> (integration-db/get-config tx project-id (constantly cov/settings-properties))
                                            (integration-db/resolve-presets tx
                                                                            {:cov-qg-preset qg-preset-desc}
                                                                            scope))
          exclude-content-from-coverage (not-empty code-coverage-exclusions-content)
          gates (pr-check/conf->gates data)]
      (when (pr-check/check-enabled? config-set)
        (map-of project-id exclusion-filter exclude-content whitelist-content
                exclude-content-from-coverage gates)))))