(ns codescene.features.core
  (:require [clojure.string :as str]
            [integrant.core :as ig]
            [duct.core :as duct]
            [duct.core.env :as duct-env]
            [clojure.java.io :as io]
            [meta-merge.core :refer [meta-merge]]
            [taoensso.timbre :as log]))

(duct/load-hierarchy)

(defmethod duct-env/coerce 'Coll-Comma [x _]
  (some-> x (str/split #",") vec))

(defmethod duct-env/coerce 'Coll-Semicolon [x _]
  (some-> x (str/split #";") vec))

(defmethod duct-env/coerce 'Coll-Colon [x _]
  (some-> x (str/split #":") vec))

(defn- log-system [system]
  (log/infof "The following duct keys have been initialized: %s"
             (vec (map (fn[[k v]] (if (map? v) [k (keys v)] [k])) system)))
  system)

(defn init
  [{:keys [config-files configs readers profiles ks]
    :or {ks [:codescene/component] profiles [:duct.profile/prod] readers {}}}]
  (log/infof "Initializing features components with profiles: %s, keys: %s"
             (vec profiles) ks)
  (-> (apply meta-merge (concat (->> config-files
                                     (filter some?)
                                     (map #(duct/read-config (io/resource %) readers)))
                                configs))
      (duct/prep-config (filter some? profiles))
      (ig/init (or ks [:codescene/component]))
      log-system))

(defn halt
  [system]
  (some-> system ig/halt!))
