(ns codescene.features.components.ff
  (:require [clojure.spec.alpha :as s]))

(defprotocol FFComponent
  (-on?
    [this flag]
    [this flag account-id]))

(defn on?
  "Return true if flag is on for entire product or for a particular account-id"
  ([this flag]
  (-on? this flag))
  ([this flag account-id]
   (-on? this flag account-id)))

(s/fdef on?
        :args (s/or :two (s/cat :this some?
                                :flag keyword?)
                    :three (s/cat :this some?
                                :flag keyword?
                                :account-id pos-int?))
        :ret boolean?)