(ns codescene.features.code-coverage.parsers.edn-parser
  (:require [clojure.edn :as edn]
            [codescene.features.code-coverage.parser :refer [Parser]]
            [clojure.java.io :as io]))

(def ^:private supported-metrics [:line-coverage
                                  :method-coverage
                                  :condition-decision-coverage
                                  :decision-coverage
                                  :statement-coverage
                                  :branch-coverage
                                  :sequence-point-coverage
                                  :condition-coverage
                                  :function-coverage])

(defn- read-coverage* [reader]
  (-> reader slurp edn/read-string))

(defn- read-coverage [f]
  (with-open [r (io/reader f)]
    (doall (read-coverage* r))))

(defn ->Parser []
  (reify Parser
    (-read-coverage [this reader _parse-options] (read-coverage* reader))
    (-supported-metrics [this] supported-metrics)
    (-id [this] "edn")
    (-name [this] "edn")))
