(ns codescene.features.client.oidc
  (:require [clj-http.client :as http-client]
            [codescene.features.util.url :as url]
            [medley.core :as m]))

(defn create-config
  "Creates an open ID configuration that closes over OIDC metadata to provide
  two functions that query introspect and user-info endpoints of the provider."
  [config http-client-config]
  (m/assoc-some {:config config}
    :introspect (when (:introspection_endpoint config)
                  #(->> (merge http-client-config {:oauth-token % :as :json})
                        (http-client/get (:introspection_endpoint config))
                        :body))
    :user-info (when (:userinfo_endpoint config)
                 #(->> (merge http-client-config {:oauth-token % :as :json})
                       (http-client/get (:userinfo_endpoint config))
                       :body))))

(defn open-id-configuration
  [url http-client-config]
  (-> (url/make-url url "/.well-known/openid-configuration")
      (http-client/get (merge http-client-config {:as :json}))
      :body
      (create-config http-client-config)))

(defn oauth2-spec [config]
  {:authorize-url (-> config :config :authorization_endpoint)
   :access-token-url (-> config :config :token_endpoint)})