(ns codescene.features.analytics.events
  (:require [medley.core :as m]))

(defn- amplitude-friendly-trace
  "Make sure the trace is accepted by amplitude,
   meaning make it vector of strings with a limit on the number of elements"
  [max-trace-size trace]
  (let [count (count trace)
        half-trace (int (/ max-trace-size 2))]
    (->> (if (> count max-trace-size)
           (concat (take half-trace trace) ["..."] (drop (- count half-trace) trace))
           trace)
         (mapv str))))

(defn- amplitude-friendly-cause
  [m]
  (-> (select-keys m [:type :at])
      (m/assoc-some :ex-type (get-in m [:data :type]))))

(defn exception->error
  " Make sure we only include unsensitive data, ie nothing that could potentially 
    reveal anything about the customers environment/data
    We do that by being explicit about what keys to include in the event"
  ([exception]
   (exception->error exception 200))
  ([exception max-trace-size]
   (let [{:keys [trace via]} (Throwable->map exception)]
     {:trace (amplitude-friendly-trace max-trace-size trace)
      :via (map amplitude-friendly-cause via)})))
   



