// @flow
import $ from 'jquery';

export function setup(nav : $, tabContent : $, defaultId : string, callback? : () => void) {
  // This is added in Javascript to start hiding inactive tabs only if the
  // client has Javascript enabled. Otherwise they will see all tabs.
  tabContent.addClass('tabs');

  var navItems = nav.find('li');
  var tabs = tabContent.find('.tab');

  function onTabChange(id) {
    if (!id) {
      return onTabChange(defaultId);
    }

    tabs.removeClass('active');
    var selectedTab = tabs.filter('[data-tab-id=' + id + ']');

    if (selectedTab.length === 0) {
      location.hash = '#' + defaultId;
    } else {
      selectedTab.addClass('active');

      navItems.removeClass('active');
      navItems.filter('[data-tab-id=' + id + ']').addClass('active');
    }

    if (typeof callback === 'function') {
      callback();
    }
  }

  function navigateToHashTab() {
    onTabChange(location.hash.substring(1));
  }

  window.onhashchange = navigateToHashTab;
  navigateToHashTab();
}



