// @flow
import $ from 'jquery';

import * as groups from 'codescene-ui/src/configuration/groups';
import { init as initSshKeysForm } from 'codescene-ui/src/configuration/ssh-keys';
import { initGroupName } from 'codescene-ui/src/configuration/group';


function makeSameRoleId(roleId){
  return function(_index, el){
    return $(el).find('.user-role-select').val() === roleId;
  };
}

// Safe to expose here since we do server side authorization and you need to be
// an Administrator.
function deleteRoleMapping(providerId, userName, groupId, roleId) {
  if (!confirm('Are you sure you want to delete the mapping for ' + userName + '?')) {
    return false;
  }

  $.ajax({type: 'DELETE',
    url: window.baseUrl + 'groups/' + groupId + '/role-mapping',
    data: { username: userName, 'provider-id': providerId, 'group-id': groupId, 'role-id': roleId },
    success: function() {
      $('tr[data-username="' + userName + '"]').filter(makeSameRoleId(roleId)).remove();
    },
    error: function() {
      alert('Failed to delete ' + userName);
    }
  });
  return true;
}

export function init() {
  $('#default-role').on('change', function () {
    const $select = $(this);
    const groupId = $select.data('group-id');
    const roleId = $select.val();
    $.ajax({
      type: 'POST',
      url: window.baseUrl + 'groups/' + groupId + '/default-role',
      data: {
        'role-id': roleId
      },
      success: function() {
        $select.data('role-id', roleId);
      },
      error: function () {
        alert('Failed to set default role');
      }
    });
  });
  $('.user-role-select').on('change', function () {
    const progressIndicator = $(this).closest('tr').find('.save-progress-indicator');
    progressIndicator
      .addClass('fa-circle-o-notch')
      .addClass('spinning');
    const $select = $(this);
    const providerId = $select.data('provider-id');
    const userName = $select.data('username');
    const groupId = $select.data('group-id');
    const oldRoleId = $select.data('role-id');
    const roleId = $select.val();
    $.ajax({
      type: 'POST',
      url: window.baseUrl + 'groups/' + groupId + '/role-mapping',
      data: {
        username: userName,
        'provider-id': providerId,
        'group-id': groupId,
        'role-id': roleId,
        'old-role-id': oldRoleId
      },
      success: function() {
        $select.data('role-id', roleId);
        progressIndicator
          .addClass('fa-check')
          .removeClass('fa-circle-o-notch')
          .removeClass('spinning');

      },
      error: function () {
        progressIndicator
          .addClass('fa-exclamation-triangle')
          .removeClass('fa-circle-o-notch')
          .removeClass('spinning');

        alert('Failed to assign user role for ' + userName);
      }
    });
  });

  $('.user-delete').on('click', function () {
    const $button = $(this);
    const providerId = $button.data('provider-id');
    const userName = $button.data('username');
    const groupId = $button.data('group-id');
    const roleId = $button.closest('tr').find('.user-role-select').val();
    deleteRoleMapping(providerId, userName, groupId, roleId);
  });
}

export const initGroupControls = groups.initGroupControls;

export {
  initSshKeysForm, initGroupName
};
