// @flow
import $ from 'jquery';
import * as markdownEditor from 'codescene-ui/src/shared/markdown-editor/markdown-editor.tsx';

// Safe to expose here since we do server side authorization and you need to be
// an Administrator.
function deleteUser(id, name) {
  if (!confirm('Are you sure you want to delete the user ' + name + '?')) {
    return false;
  }

  $.ajax({type: 'POST',
    url: window.baseUrl + 'configuration/user/delete',
    data: { 'user-id': id },
    success: function() {
      $('tr[data-user-id=' + id + ']').remove();
    },
    error: function() {
      alert('Failed to delete ' + name);
    }
  });
  return true;
}

function changePassword(id, userName) {
  var newPassword = prompt('Please enter a new password for ' + userName + '.');

  if (newPassword != null) {
    $.ajax({
      type: 'POST',
      url: window.baseUrl + 'configuration/user/password',
      data: { 'user-id': id, password: newPassword },
      error: function(request) {
        alert('Failed to change the password for ' + userName + '\n\n' + request.responseText);
      }
    });

    return true;
  }

  return false;
}

function setupLdapAuthProviderVisibilityToggle() {
  var ldapAuthProviderBlock = $('.ldap-auth-provider-toggleable');
  var ldapAuthProviderIsActiveCheckbox = $('#ldap-active');
  ldapAuthProviderIsActiveCheckbox.click(function() {
    ldapAuthProviderBlock.toggle();
  });
}

function addDeleteButtonsHandlers() {
  $('.role-mapping-delete-entry').on('click', function () {
    var button = $(this);
    button.closest('tr').remove();
  });
}

function addNewLdapRoleMapping() {
  var ldapObjectId = $('#ldap-role-mapping-new-entry-id').val();
  var codesceneRole = $('#ldap-role-mapping-new-entry-role').val();
  var roleMappingsTable = $('#ldap-existing-role-mappings-table');
  // clone the first hidden row
  var newMappingRow = roleMappingsTable.find('tr:eq(1)').clone();
  // make sure it's not hidden anymore
  newMappingRow.css('display', 'table-row');
  // and copy LDAP user/group id and codescene role from the above input fields
  newMappingRow.find('input:text').val(ldapObjectId);
  newMappingRow.find('select').val(codesceneRole);
  // the color is @codesceneSoftYellow
  newMappingRow.css('background', '#FEFCD7');
  newMappingRow.prependTo(roleMappingsTable);
  // must call addDeleteButtonsHandlers again to make sure that we may delete the just added row
  // without having to submit the form first
  addDeleteButtonsHandlers();
}

function setupOAuth2AuthProviderVisibilityToggle() {
  var oauth2AuthProviderBlock = $('.oauth2-auth-provider-toggleable');
  var oauth2AuthProviderIsActiveCheckbox = $('#oauth2-active');
  oauth2AuthProviderIsActiveCheckbox.click(function() {
    oauth2AuthProviderBlock.toggle();
  });
}

const updateLoginMessageField = (value: string) => {
  $('#login-page-message').val(value);
};

function addNewOAuth2RoleMapping() {
  var objectId = $('#oauth2-role-mapping-new-entry-id').val();
  var codesceneRole = $('#oauth2-role-mapping-new-entry-role').val();
  var roleMappingsTable = $('#oauth2-existing-role-mappings-table');
  // clone the first hidden row
  var newMappingRow = roleMappingsTable.find('tr:eq(1)').clone();
  // make sure it's not hidden anymore
  newMappingRow.css('display', 'table-row');
  // and copy OAuth2 user/group id and codescene role from the above input fields
  newMappingRow.find('input:text').val(objectId);
  newMappingRow.find('select').val(codesceneRole);
  // the color is @codesceneSoftYellow
  newMappingRow.css('background', '#FEFCD7');
  newMappingRow.prependTo(roleMappingsTable);
  // must call addDeleteButtonsHandlers again to make sure that we may delete the just added row
  // without having to submit the form first
  addDeleteButtonsHandlers();
}

function oauth2GitHubSettings(){
  $('#oauth2-provider-name').val('GitHub');
  $('#oauth2-authorization-url').val('https://github.com/login/oauth/authorize');
  $('#oauth2-access-token-url').val('https://github.com/login/oauth/access_token');
  $('#oauth2-scope').val('read:org');
  $('#oauth2-user-url').val('https://api.github.com/user');
  $('#oauth2-username-field').val('$.login');
  $('#oauth2-teams-url').val('https://api.github.com/user/teams');
  $('#oauth2-teamname-field').val('$[*].name');
}

function oauth2GitLabSettings(){
  $('#oauth2-provider-name').val('GitLab');
  $('#oauth2-authorization-url').val('https://gitlab.com/oauth/authorize');
  $('#oauth2-access-token-url').val('https://gitlab.com/oauth/token');
  $('#oauth2-scope').val('api');
  $('#oauth2-user-url').val('https://gitlab.com/api/v4/user');
  $('#oauth2-username-field').val('$.username');
  $('#oauth2-teams-url').val('https://gitlab.com/api/v4/groups');
  $('#oauth2-teamname-field').val('$[*].name');
}

function oauth2BitBucketSettings(){
  $('#oauth2-provider-name').val('BitBucket');
  $('#oauth2-authorization-url').val('https://bitbucket.org/site/oauth2/authorize');
  $('#oauth2-access-token-url').val('https://bitbucket.org/site/oauth2/access_token');
  $('#oauth2-scope').val('account');
  $('#oauth2-user-url').val('https://api.bitbucket.org/2.0/user');
  $('#oauth2-username-field').val('$.username');
  $('#oauth2-teams-url').val('https://api.bitbucket.org/2.0/teams?role=member');
  $('#oauth2-teamname-field').val('$.values[*].username');
}

function oauth2GoogleSettings(){
  $('#oauth2-provider-name').val('Google Id');
  $('#oauth2-authorization-url').val('https://accounts.google.com/o/oauth2/v2/auth');
  $('#oauth2-access-token-url').val('https://oauth2.googleapis.com/token');
  $('#oauth2-scope').val('openid profile email');
  $('#oauth2-user-url').val('https://openidconnect.googleapis.com/v1/userinfo');
  $('#oauth2-username-field').val('$.email');
  $('#oauth2-teams-url').val('');
  $('#oauth2-teamname-field').val('');
}

function oauth2AzureSettings(){
  $('#oauth2-provider-name').val('Azure AD');
  $('#oauth2-authorization-url').val('https://login.microsoftonline.com/common/oauth2/v2.0/authorize');
  $('#oauth2-access-token-url').val('https://login.microsoftonline.com/common/oauth2/v2.0/token');
  $('#oauth2-scope').val('openid email profile https://graph.microsoft.com/user.read https://graph.microsoft.com/directory.read.all');
  $('#oauth2-user-url').val('https://graph.microsoft.com/v1.0/me');
  $('#oauth2-username-field').val('$.userPrincipalName');
  $('#oauth2-teams-url').val('https://graph.microsoft.com/v1.0/me/memberOf');
  $('#oauth2-teamname-field').val('$.value[*].displayName');
}

export function init(loginMessage) {
  $('.user-role-select').on('change', function () {
    var $select = $(this);
    var userName = $select.data('user-name');
    var roleId = $select.val();
    $.ajax({
      type: 'POST',
      url: window.baseUrl + 'configuration/user/role',
      data: { 'user-name': userName, 'role-id': roleId },
      error: function () {
        alert('Failed to assign user role for ' + userName);
      }
    });
  });

  $('.user-change-password').on('click', function () {
    var $button = $(this);
    var userId = $button.data('user-id');
    var userName = $button.data('user-name');
    changePassword(userId, userName);
  });

  $('.user-delete').on('click', function () {
    var $button = $(this);
    var userId = $button.data('user-id');
    var userName = $button.data('user-name');
    deleteUser(userId, userName);
  });

  $('#ldap-role-mapping-new-entry-add').on('click', addNewLdapRoleMapping);
  $('#oauth2-role-mapping-new-entry-add').on('click', addNewOAuth2RoleMapping);
  $('#oauth2-github-settings').on('click', oauth2GitHubSettings);
  $('#oauth2-gitlab-settings').on('click', oauth2GitLabSettings);
  $('#oauth2-bitbucket-settings').on('click', oauth2BitBucketSettings);
  $('#oauth2-google-settings').on('click', oauth2GoogleSettings);
  $('#oauth2-azure-settings').on('click', oauth2AzureSettings);

  addDeleteButtonsHandlers();

  setupLdapAuthProviderVisibilityToggle();
  setupOAuth2AuthProviderVisibilityToggle();

  markdownEditor.init($('#login-message')[0], loginMessage, updateLoginMessageField);
}
